% Keithley KPCI-3108
% Ananlog Input on Digital Trigger
fprintf('Connect the Trigger line to (IP1) Pin 3 of STP-36 on upper Ananlog connector') 

% 1. create device object
    ai = analoginput('keithley',0); 
% 2. Add channels
    ch = addchannel(ai,0:2);
% 3. Configure property values 
    sfreq = 10000;
    nPoints = 1000;
    set(ai,'SampleRate',sfreq)
    set(ai,'SamplesPerTrigger',nPoints)
    

%4. Configure for Digital Trigger
    set(ai,'ChannelSkewMode','Equisample')%The channel skew is 
    set(ai,'TriggerChannel',ch(1))
    set(ai,'TriggerType','HwDigital')    
    set(ai,'TriggerCondition','Rising') 
    set(ai,'Timeout',10)        %10 sec
%5. Get data   
    start(ai)
    [data,time] = getdata(ai);
%6. Plot Data
    subplot(3,1,1)
    plot(time(1:50),data(1:50,1),'r'),ylabel('Ch0 (V)'),title('KPCI-3108: Digital Trigger (rising) on IP1') 
    subplot(3,1,2)
    plot(time(1:50),data(1:50,2),'b'),ylabel('Ch1 (V)') 
    subplot(3,1,3)
    plot(time(1:50),data(1:50,3),'m'),ylabel('Ch2 (V)'),xlabel('relative time(sec)') 



%7. clear the memory
    delete(ai) 
    clear ai     
    clear all